DROP PROCEDURE [hips].[DocumentTypeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Created date:  12 Oct 2012
-- Description:   Gets all records or a specific record from the DocumentType table
-- Modified:
-- 04/12/2013 - Simon Biber - Return repository information
-- =============================================
CREatE PROCEDURE [hips].[DocumentTypeGet] 
(
	@DocumentTypeId INT = null
)
AS
BEGIN
SELECT  dt.DocumentTypeId,
		dt.Description,
		dt.Code,
		dt.DateCreated,
		dt.UserCreated,
		dt.DateModified,
		dt.UserModified,
		dt.RepositoryId,
		r.Description AS RepositoryDescription,
		r.RepositoryUniqueId
		
FROM  hips.DocumentType dt
INNER JOIN hips.Repository r ON dt.RepositoryId = r.RepositoryId
WHERE dt.DocumentTypeId = @DocumentTypeId OR @DocumentTypeId IS NULL
ORDER BY dt.Description asc
END
GO

